﻿using System;
using System.Runtime.InteropServices;
using System.Security.Principal;

namespace WorkerRole
{
    public static class Extensions
    {
        [DllImport("advapi32.dll", SetLastError = true, CharSet = CharSet.Unicode)]
        public static extern bool LogonUser(String lpszUsername, String lpszDomain, String lpszPassword, int dwLogonType, int dwLogonProvider, out SafeTokenHandle phToken);

        public static TOut ExecuteAs<TIn, TOut>(this Func<TIn, TOut> funcToExecute, string username, string password, string domain, TIn inputArg)
        {
            SafeTokenHandle safeTokenHandle;
            var returnValue = LogonUser(username, domain, password, 2, 0, out safeTokenHandle);

            if (returnValue)
            {
                using (safeTokenHandle)
                {
                    using (var impersonatedUser = WindowsIdentity.Impersonate(safeTokenHandle.DangerousGetHandle()))
                    {
                       return funcToExecute(inputArg);
                    }
                }

            }
            else
            {
                throw new Exception(string.Format("User {0} login failed", username));    
            }
        }        
        
        public static void ExecuteAs(this Action actionToExecute, string username, string password, string domain)
        {
            SafeTokenHandle safeTokenHandle;
            var returnValue = LogonUser(username, domain, password, 2, 0, out safeTokenHandle);

            if (returnValue)
            {
                using (safeTokenHandle)
                {
                    using (var impersonatedUser = WindowsIdentity.Impersonate(safeTokenHandle.DangerousGetHandle()))
                    {
                        actionToExecute();
                    }
                }
            }
            else
            {
                throw new Exception(string.Format("User {0} login failed", username));    
            }
        }
    }
}