﻿using System;
using System.Threading;

namespace TestClasses
{
    public class TestClass
    {
        private readonly int _maxSleepTime;
        private readonly Random _rand = new Random();

        private string ThreadSleepRandom(string methodName)
        {
            int sleep = _rand.Next(_maxSleepTime);
            Thread.Sleep(sleep);
            return (string.Format("Method '{0}' execution slept for {1} milliseconds", methodName, sleep));
        }

        public TestClass(int maxSleepTime)
        {
            _maxSleepTime = maxSleepTime;
        }

        public string TestMethod()
        {
            return ThreadSleepRandom("TestMethod()");
        }

        public string TestMethod2()
        {
            return ThreadSleepRandom("TestMethod2()");
        }

        public string TestMethod3()
        {
            return ThreadSleepRandom("TestMethod3()");
        }
    }
}