﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Threading.Tasks;

namespace TestClasses
{
    public static class TestClassRunner
    {
        public static void Run()
        {
            var testClass = new TestClass(100000);

            IList<Task> tasks = new List<Task>();

            Trace.TraceInformation("Starting the tests");

            tasks.Add(Task.Factory.StartNew(() =>
            {
                while(true)
                {
                    try
                    {
                        Trace.TraceInformation(testClass.TestMethod());
                    }
                    catch (Exception e)
                    {
                        Trace.TraceError(string.Format("Exception was thrown on TestMethod(). See exception stack trace for more details: {0}", e));
                    }
                }
            }, TaskCreationOptions.LongRunning));

            tasks.Add(Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Trace.TraceInformation(testClass.TestMethod2());
                    }
                    catch (Exception e)
                    {
                        Trace.TraceError(string.Format("Exception was thrown on TestMethod2(). See exception stack trace for more details: {0}", e));
                    }
                }
            }, TaskCreationOptions.LongRunning));

            tasks.Add(Task.Factory.StartNew(() =>
            {
                while (true)
                {
                    try
                    {
                        Trace.TraceInformation(testClass.TestMethod3());
                    }
                    catch (Exception e)
                    {
                        Trace.TraceError(string.Format("Exception was thrown on TestMethod3(). See exception stack trace for more details: {0}", e));
                    }
                }
            }, TaskCreationOptions.LongRunning));

            Task.WaitAll(tasks.ToArray());
        }
    }
}