﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.IO;
using System.Linq;
using Aspects;

namespace TestConsole
{
    [AverageTimePerformanceCounterAspect(AttributeExclude = true)]
    public class PerformanceCountersAspectsSettingsManager : IPerformanceCountersAspectsSettingsManager
    {
        readonly FileSystemWatcher _fileWatcher = new FileSystemWatcher(Path.GetDirectoryName(AppDomain.CurrentDomain.SetupInformation.ConfigurationFile), Path.GetFileName(AppDomain.CurrentDomain.SetupInformation.ConfigurationFile));

        public PerformanceCountersAspectsSettingsManager()
        {
            _fileWatcher.Changed += (sender, args) => OnConfigurationChanged();
            _fileWatcher.EnableRaisingEvents = true;
        }

        public event EventHandler ConfigurationChanged;

        public IEnumerable<string> MembersToMeasured
        {
            get { return ConfigurationManager.AppSettings["MembersToBeMeasured"].Split(';'); }
        }

        protected virtual void OnConfigurationChanged()
        {
            EventHandler handler = ConfigurationChanged;
            if (handler != null)
            {
                handler(this, EventArgs.Empty);
            }
        }
    }
}