using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Net;
using System.Threading;
using Aspects;
using Microsoft.WindowsAzure;
using Microsoft.WindowsAzure.Diagnostics;
using Microsoft.WindowsAzure.ServiceRuntime;
using Microsoft.WindowsAzure.Storage;
using TestClasses;

namespace WorkerRole
{
    public class WorkerRole : RoleEntryPoint
    {
        readonly CancellationTokenSource _cancelSource = new CancellationTokenSource();

        public WorkerRole()
        {
            PerformanceCountersAspectsServiceLocator.PerformanceCountersAspectsSettingsManager = new PerformanceCountersAspectsSettingsManager();
        }

        public override void Run()
        {
            Trace.TraceInformation("Role running");
            TestClassRunner.Run();
            _cancelSource.Token.WaitHandle.WaitOne();
        }

        public override bool OnStart()
        {
            // Set the maximum number of concurrent connections 
            ServicePointManager.DefaultConnectionLimit = 12;

            // For information on handling configuration changes
            // see the MSDN topic at http://go.microsoft.com/fwlink/?LinkId=166357.

            Trace.TraceInformation("Role starting");
            return base.OnStart();
        }

        public override void OnStop()
        {
            Trace.TraceInformation("Role stopping");
            base.OnStop();
        }
    }
}
